<div class="bbcode-editor">
    <div class="bbcode-toolbar">
        <div class="toolbar-group">
            <button type="button" class="toolbar-btn" data-bbcode="b" title="Bold">
                <i class="fas fa-bold"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="i" title="Italic">
                <i class="fas fa-italic"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="u" title="Underline">
                <i class="fas fa-underline"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="s" title="Strikethrough">
                <i class="fas fa-strikethrough"></i>
            </button>
        </div>
        
        <div class="toolbar-group">
            <button type="button" class="toolbar-btn" data-bbcode="url" title="Link">
                <i class="fas fa-link"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="img" title="Image">
                <i class="fas fa-image"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="code" title="Code">
                <i class="fas fa-code"></i>
            </button>
        </div>
        
        <div class="toolbar-group">
            <button type="button" class="toolbar-btn" data-bbcode="quote" title="Quote">
                <i class="fas fa-quote-right"></i>
            </button>
            <button type="button" class="toolbar-btn" data-bbcode="list" title="List">
                <i class="fas fa-list"></i>
            </button>
        </div>
        
        <div class="toolbar-group emoji-group">
            <button type="button" class="toolbar-btn emoji-btn" title="Emojis">
                <i class="far fa-smile"></i>
            </button>
            <div class="emoji-picker">
                <div class="emoji-item" data-emoji="😀">😀</div>
                <div class="emoji-item" data-emoji="😂">😂</div>
                <div class="emoji-item" data-emoji="😎">😎</div>
                <div class="emoji-item" data-emoji="❤️">❤️</div>
                <div class="emoji-item" data-emoji="👍">👍</div>
                <div class="emoji-item" data-emoji="🎮">🎮</div>
                <div class="emoji-item" data-emoji="🔥">🔥</div>
                <div class="emoji-item" data-emoji="🤔">🤔</div>
            </div>
        </div>
    </div>
    
    <textarea 
        name="{{ $name }}" 
        id="bbcode-textarea-{{ $name }}" 
        class="bbcode-textarea" 
        placeholder="{{ $placeholder }}"
        style="min-height: {{ $height }};"
    >{{ $content }}</textarea>
    
    <div class="bbcode-footer">
        <button type="button" class="preview-btn">Preview</button>
    </div>
    
    <div class="bbcode-preview" style="display: none; min-height: {{ $height }};">
        <!-- Preview content will be loaded here -->
    </div>
</div>